<?php
// ambil kode v dari parameter
$v = isset($_GET['v']) ? $_GET['v'] : '0';

// include file url.php supaya fungsi getDomain() tersedia
include "url.php";

// ambil domain
$domain = getDomain($v);

// kalau domain kosong / tidak valid
if (empty($domain)) {
    echo "<!-- domain not found -->";
    exit;
}

// ambil keyword dari file
$keywordFile = "data.txt";
if (!file_exists($keywordFile)) {
    echo "<!-- data file not found -->";
    exit;
}

$keywords = file($keywordFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

echo '<div style="display:none;">' . PHP_EOL;

// generate anchor untuk setiap keyword
foreach ($keywords as $kw) {
    $kw = trim($kw);
    if ($kw === '') continue;

    echo '<a href="' . htmlspecialchars($domain, ENT_QUOTES, 'UTF-8') . '">'
         . htmlspecialchars($kw, ENT_QUOTES, 'UTF-8') . '</a>' . PHP_EOL;
}

echo "</div>" . PHP_EOL;
?>
