<?php
/**
 * Simple Gate + File Browser (1 file)
 * Folder: /public_html/__boyram/index.php
 * Password: ohtidakbisa
 */

session_start();

// ===== Konfigurasi =====
$PASSWORD = "ohtidakbisa";
$ERROR_IMG = "https://kurama-co-in-dgr.pages.dev/kone.png";
// =======================

// --- Auth sangat simpel ---
if (!isset($_SESSION['ok'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $pwd = isset($_POST['pwd']) ? trim($_POST['pwd']) : '';
        if (hash_equals($PASSWORD, $pwd)) {
            $_SESSION['ok'] = true;
            // reload ke halaman utama setelah login
            header("Location: ".$_SERVER['PHP_SELF']);
            exit;
        } else {
            // Password salah → tampil gambar & berhenti
            echo "<div style='text-align:center;margin-top:40px'>
                    <img src='{$ERROR_IMG}' alt='Error'>
                  </div>";
            exit;
        }
    }

    // Form password (belum login)
    echo '<!doctype html><html lang="id"><head><meta charset="utf-8">
          <meta name="viewport" content="width=device-width,initial-scale=1">
          <title>Masuk</title>
          <style>
          body{font-family:system-ui,Arial;background:#0f172a;color:#e5e7eb;display:flex;align-items:center;justify-content:center;height:100vh;margin:0}
          .card{background:#111827;border:1px solid #1f2937;border-radius:14px;padding:26px;box-shadow:0 8px 24px rgba(0,0,0,.35);width:100%;max-width:360px}
          h1{margin:0 0 12px;font-size:20px}
          p{opacity:.8;margin:0 0 16px}
          input[type=password]{width:100%;padding:12px;border-radius:10px;border:1px solid #374151;background:#0b1220;color:#e5e7eb}
          button{width:100%;margin-top:12px;padding:12px;border:0;border-radius:10px;background:#2563eb;color:#fff;font-weight:600;cursor:pointer}
          </style></head><body>
          <form class="card" method="post" autocomplete="off">
            <h1>Masukkan Password</h1>
            <p>Akses folder ini terbatas.</p>
            <input type="password" name="pwd" placeholder="Password" required>
            <button type="submit">Masuk</button>
          </form></body></html>';
    exit;
}

// --- Kalau sudah login: file browser sederhana ---
$base = realpath(__DIR__);              // /__boyram
$req  = isset($_GET['p']) ? $_GET['p'] : '';
$req  = str_replace(["\\", "\0"], "/", $req); // normalisasi
$req  = preg_replace('#(^/|/+$)#', '', $req); // trim slash di awal/akhir
$req  = preg_replace('#\.\.+#', '', $req);    // cegah ../

$path = $base;
if ($req !== '') {
    $tmp = realpath($base . DIRECTORY_SEPARATOR . $req);
    if ($tmp !== false && strpos($tmp, $base) === 0) {
        $path = $tmp;
    }
}
$rel  = ltrim(str_replace($base, '', $path), DIRECTORY_SEPARATOR);

// Ambil daftar isi
$items = @scandir($path);
if ($items === false) {
    http_response_code(404);
    die("Folder tidak ditemukan.");
}

// Pisahkan folder & file
$dirs = $files = [];
foreach ($items as $i) {
    if ($i === '.' || $i === '..') continue;
    if ($rel === '' && $i === basename(__FILE__)) continue; // sembunyikan index.php di root
    if (substr($i, 0, 1) === '.') continue; // sembunyikan dotfiles
    $full = $path . DIRECTORY_SEPARATOR . $i;
    if (is_dir($full)) $dirs[] = $i; else $files[] = $i;
}

// Helper buat URL relatif
function href($r, $add) {
    $r = trim($r, '/');
    $add = trim($add, '/');
    $next = $r ? "$r/$add" : $add;
    return htmlspecialchars($_SERVER['PHP_SELF'].'?p='.$next, ENT_QUOTES, 'UTF-8');
}
function file_url($rel, $name) {
    $rel = trim($rel, '/');
    $p = $rel ? "$rel/$name" : $name;
    // URL publik relatif ke /__boyram/
    return htmlspecialchars($p, ENT_QUOTES, 'UTF-8');
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>__boyram Browser</title>
<style>
body{font-family:system-ui,Arial;background:#0b1220;color:#e5e7eb;margin:0}
.header{padding:14px 18px;background:#111827;border-bottom:1px solid #1f2937;display:flex;gap:10px;align-items:center;flex-wrap:wrap}
.path{font-size:14px;opacity:.9}
.container{max-width:980px;margin:24px auto;padding:0 16px}
.grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(240px,1fr));gap:12px}
.card{background:#0f172a;border:1px solid #1f2937;border-radius:12px;padding:14px}
a{color:#93c5fd;text-decoration:none}
a:hover{text-decoration:underline}
.badge{display:inline-block;font-size:12px;opacity:.8;margin-left:8px}
.footer{opacity:.6;text-align:center;margin:28px 0 18px;font-size:12px}
.btn{background:#2563eb;color:#fff;border:0;border-radius:10px;padding:8px 12px}
</style>
</head>
<body>
  <div class="header">
    <strong>__boyram</strong>
    <span class="path">/<?= htmlspecialchars($rel ?: '.', ENT_QUOTES, 'UTF-8'); ?></span>
    <?php if ($rel): ?>
      <a class="btn" href="<?= htmlspecialchars($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8'); ?>">Root</a>
      <?php
        $parts = explode('/', $rel);
        array_pop($parts);
        $up = implode('/', $parts);
      ?>
      <a class="btn" href="<?= htmlspecialchars($_SERVER['PHP_SELF'].'?p='.$up, ENT_QUOTES, 'UTF-8'); ?>">Up</a>
    <?php endif; ?>
  </div>

  <div class="container">
    <h3>Folder</h3>
    <div class="grid">
      <?php if (!$dirs): ?>
        <div class="card">Tidak ada folder</div>
      <?php else: foreach ($dirs as $d): ?>
        <div class="card">
          <div>📁 <a href="<?= href($rel, $d); ?>"><?= htmlspecialchars($d, ENT_QUOTES, 'UTF-8'); ?></a></div>
          <span class="badge">folder</span>
        </div>
      <?php endforeach; endif; ?>
    </div>

    <h3 style="margin-top:18px">File</h3>
    <div class="grid">
      <?php if (!$files): ?>
        <div class="card">Tidak ada file</div>
      <?php else: foreach ($files as $f): ?>
        <div class="card">
          <div>📄 <a href="<?= file_url($rel, $f); ?>" target="_blank" rel="noopener"><?= htmlspecialchars($f, ENT_QUOTES, 'UTF-8'); ?></a></div>
          <span class="badge">file</span>
        </div>
      <?php endforeach; endif; ?>
    </div>
  </div>

  <div class="footer">Sesi aktif. <a href="<?= htmlspecialchars($_SERVER['PHP_SELF'].'?logout=1', ENT_QUOTES, 'UTF-8'); ?>">Keluar</a></div>
</body>
</html>
<?php
// Logout opsional
if (isset($_GET['logout'])) {
    unset($_SESSION['ok']);
    session_destroy();
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}
